%	By Yisong Chen and Jiewei Sun 2010.
%	copyright Peking University.
%   Reference: Yisong Chen, Jiewei Sun, Minimizing Geometric Distance by Iterative Linear Optimization. ICPR2010.

clear all;
close all;

H=magic(3);
H(1,3)=-H(1,3);
H(2,2)=-H(2,2);
H(1:2,:)=10*H(1:2,:);
H=H./norm(H,'fro')
Hn=H;

Thres=1000000.0;
bias_o=1.00;
num=50;       
trialNum=11;   

result_dgeo=zeros(trialNum,5);  
result_time=zeros(trialNum,5);
result_dh=zeros(trialNum,5);

trial=0;
while (trial<trialNum)        
    Pi=20*rand(2,num)-10;  
    wi=ones(1,num);
    Pih=[Pi;wi];           
    Pth=H*Pih;             
    Pt=Pth(1:2,:)./[Pth(3,:);Pth(3,:)];  
    Po=Pt+bias_o*randn(2,num);           
    wo=ones(1,num);
    Poh=[Po;wo];
    A=zeros(num*2,9);
    
    trial=trial+1;
    fprintf('trial %d started\n',trial);
    
    %disp('--------strategy 1: original DLT linear optimization---------');
    wi=ones(1,num);
    Pih=[Pi;wi];  
    wo=ones(1,num);
    Poh=[Po;wo];
    A=zeros(num*2,9);
    tic;
    for i=1:num
        index=2*i-1;
        A(2*i-1,:)=[zeros(1,3)     -wo(i)*Pih(:,i)'     Poh(2,i)*Pih(:,i)'];
        A(2*i  ,:)=[wo(i)*Pih(:,i)' zeros(1,3)         -Poh(1,i)*Pih(:,i)'];
    end 
    [U, S, V] = svd(A);
    h = V(:,length(V));
    He=[h(1) h(2) h(3)
        h(4) h(5) h(6)
        h(7) h(8) h(9)];
    Pth=He*Pih;
    wt=Pth(3,:);
    if sign(He(1))~=sign(Hn(1))
        He=-He;
    end
    H1=He;
    H1=H1./norm(H1,'fro');
    wi=ones(1,num);
    Pih=[Pi;wi];
    wo=ones(1,num);
    Poh=[Po;wo];
    Pth=H1*Pih;
    wt=Pth(3,:);
    dgeo=sum( (Poh(2,:)./wo(1,:)-Pth(2,:)./wt(1,:)).*(Poh(2,:)./wo(1,:)-Pth(2,:)./wt(1,:))+(Poh(1,:)./wo(1,:)-Pth(1,:)./wt(1,:)).*(Poh(1,:)./wo(1,:)-Pth(1,:)./wt(1,:)) );
    result_time(trial,1)=toc; 
    result_dgeo(trial,1)=sqrt(dgeo/num);        
    result_dh(trial,1)=norm(H1-H,'fro');    
        
    %disp('--------strategy 2: Solving non-linear least squares problems(Sampson error).---------');
    wi=ones(1,num);
    Pih=[Pi;wi];  
    wo=ones(1,num);
    Poh=[Po;wo];
    A=zeros(num*2,9);
    tic;
    for i=1:num
        index=2*i-1;
        A(2*i-1,:)=[zeros(1,3)     -wo(i)*Pih(:,i)'     Poh(2,i)*Pih(:,i)'];
        A(2*i  ,:)=[wo(i)*Pih(:,i)' zeros(1,3)         -Poh(1,i)*Pih(:,i)'];
    end 
    [U, S, V] = svd(A);
    h0 = V(:,length(V));                %V should be 9*9, so h0 should be a 9*1 column vector !!
    options = optimset('Display','off','Diagnostics','off'); 
    [h,squareError residual] = lsqnonlin(@squareErrorFunc,h0,-1000,1000,options, Pi, Po);   
    He=[h(1) h(2) h(3)
        h(4) h(5) h(6)
        h(7) h(8) h(9)];
    
    if sign(He(1))~=sign(Hn(1))
        He=-He;
    end
    H2=He;
    H2=H2./norm(H2,'fro');
    wi=ones(1,num);
    Pih=[Pi;wi];
    wo=ones(1,num);
    Poh=[Po;wo];
    Pth=H2*Pih;
    wt=Pth(3,:);
    dgeo=sum( (Poh(2,:)./wo(1,:)-Pth(2,:)./wt(1,:)).*(Poh(2,:)./wo(1,:)-Pth(2,:)./wt(1,:))+(Poh(1,:)./wo(1,:)-Pth(1,:)./wt(1,:)).*(Poh(1,:)./wo(1,:)-Pth(1,:)./wt(1,:)) );
    result_time(trial,2)=toc; 
    result_dgeo(trial,2)=sqrt(dgeo/num);        
    result_dh(trial,2)=norm(H2-H,'fro');    
    
    %disp('--------strategy 3: nonlinear optimization by simplex downhill method---------');
    wi=ones(1,num);
    Pih=[Pi;wi];  
    wo=ones(1,num);
    Poh=[Po;wo];
    A=zeros(num*2,9);
    tic;    
    for i=1:num
        index=2*i-1;
        A(2*i-1,:)=[zeros(1,3)     -wo(i)*Pih(:,i)'     Poh(2,i)*Pih(:,i)'];
        A(2*i  ,:)=[wo(i)*Pih(:,i)' zeros(1,3)         -Poh(1,i)*Pih(:,i)'];
    end 
    [U, S, V] = svd(A);
    h0 = V(:,length(V));
    options = optimset('Display','off','Diagnostics','off'); 
    [h,fval,exitflag,output] = fminsearch( @geoerrorFunc,h0,options,Pi,Po,num);
    He=[h(1) h(2) h(3)
        h(4) h(5) h(6)
        h(7) h(8) h(9)];
    if sign(He(1))~=sign(Hn(1))
        He=-He;
    end
    H3=He;
    H3=H3./norm(H3,'fro');
    wi=ones(1,num);
    Pih=[Pi;wi];
    wo=ones(1,num);
    Poh=[Po;wo];
    Pth=H3*Pih;
    wt=Pth(3,:);
    dgeo=sum( (Poh(2,:)./wo(1,:)-Pth(2,:)./wt(1,:)).*(Poh(2,:)./wo(1,:)-Pth(2,:)./wt(1,:))+(Poh(1,:)./wo(1,:)-Pth(1,:)./wt(1,:)).*(Poh(1,:)./wo(1,:)-Pth(1,:)./wt(1,:)) );
    result_time(trial,3)=toc; 
    result_dgeo(trial,3)=sqrt(dgeo/num);        
    result_dh(trial,3)=norm(H3-H,'fro');    
        
    %disp('--------strategy 4: iterative linear optimization----------------');
    wi=ones(1,num);
    Pih=[Pi;wi];  
    wo=ones(1,num);
    Poh=[Po;wo];
    A=zeros(num*2,9);
    tic;
    for it=1:3
        for i=1:num
            index=2*i-1;
            A(2*i-1,:)=[zeros(1,3)     -wo(i)*Pih(:,i)'     Poh(2,i)*Pih(:,i)'];
            A(2*i  ,:)=[wo(i)*Pih(:,i)' zeros(1,3)         -Poh(1,i)*Pih(:,i)'];
        end 
        [U, S, V] = svd(A);
        h = V(:,length(V));

        He=[h(1) h(2) h(3)
            h(4) h(5) h(6)
            h(7) h(8) h(9)];

        Pth=He*Pih;
        wt=Pth(3,:);
       
        s=sqrt(abs(wt.*wo));
        Pih=Pih./[s;s;s];
        wi=Pih(3,:);
        Poh=Poh./[s;s;s];
        wo=Poh(3,:); 
    end %it loop end
    if sign(He(1))~=sign(Hn(1))
        He=-He;
    end
    H4=He;
    H4=H4./norm(H4,'fro');
    wi=ones(1,num);
    Pih=[Pi;wi];
    wo=ones(1,num);
    Poh=[Po;wo];
    Pth=H4*Pih;
    wt=Pth(3,:);
    dgeo=sum( (Poh(2,:)./wo(1,:)-Pth(2,:)./wt(1,:)).*(Poh(2,:)./wo(1,:)-Pth(2,:)./wt(1,:))+(Poh(1,:)./wo(1,:)-Pth(1,:)./wt(1,:)).*(Poh(1,:)./wo(1,:)-Pth(1,:)./wt(1,:)) );
    result_time(trial,4)=toc; 
    result_dgeo(trial,4)=sqrt(dgeo/num);        
    result_dh(trial,4)=norm(H4-H,'fro');    
    
   if (result_dgeo(trial,1)>Thres)     %remove outliers due to bad DLT initialization
        fprintf('trial %d discarded\n',trial);  %cys: discard this trial and try again.
        trial=trial-1;
   end
end

figure;
hold on;
Y = result_time(2:trial,1:4);
bar(Y);
xlabel('trial');
ylabel('time(s)');
legend('DLT','Sampson','Simplex','iDLT');

figure;
hold on;
Y = result_dh(2:trial,1:4);
bar(Y);
xlabel('trial');
ylabel('norm(dH)');
legend('DLT','Sampson','Simplex','iDLT');

figure;
hold on
Y = result_dgeo(2:trial,1:4);
bar(Y);
xlabel('trial');
ylabel('Geometric error');
legend('DLT','Sampson','Simplex','iDLT');